function CheckKeys(e)
{
	var SingleCodes = [116,117,122];             // F5, F6, F11
	var CtrlCodes =   [9,69,72,73,76,78,79,82,87];  // Tab,e,h,i,l,n,o,r,w
	var AltCodes =    [36,37,39];                // Home, left arrow, right arrow   	
	var keycode;
	var ctrlKey;
	var altKey;
	var srcEl = GetEventSource(e);
	
	// compatibility IE & Firefox
	if(window.event)
	{
		keycode = window.event.keyCode;	
		ctrlKey = window.event.ctrlKey;
		altKey = window.event.altKey;
	}
	else if (e)
	{
		keycode = e.which;
		ctrlKey = e.ctrlKey;
		altKey = e.altKey;
	}   	

   if( keycode == 27 )
   {
      return true;
   }
   
   if( keycode == 13)
   {
		if(getBrowseMode() == '0')
		{
			SubmitOnEnter(e);
		}
		else
		{			
			if(FindElementByName('NAV_QUIT'))
			{				
				FindElementByName('NAV_QUIT').click();
			}
		}		
		return false;
	}

   if( keycode == 38 || keycode == 40)
   {  
      if( srcEl.type == 'checkbox')
      {  

        var coll;
	if (parent.document.all)
	    coll = parent.document.all;   // IE < 6
	else
	    coll = parent.document.getElementsByTagName('*');  // DOM

        if (keycode == 40)
        {
	for(var i=coll.length -1; i >= 0; i--) {
   	   if (coll[i] == srcEl)
           {
              var index = i+1;
	      while (coll[index] != null && coll[index].type != 'checkbox') index++;	
              var next = coll[index]; 
              
              if (next != null && !next.disabled)
              {	
                 next.focus();
                 next.select(); 		 
              } 
               return false; 
               
           }
        }

	}
	else
	{
	for(var i=0; i < coll.length; i++) {
   	   if (coll[i] == srcEl)
           {
              var index = i-1;
	      while (coll[index] != null && coll[index].type != 'checkbox') index--;	
              var next = coll[index]; 
              
              if (next != null && !next.disabled)
              {
                 next.focus();
                 next.select(); 
              } 
               return false; 
               
           }
        }

	}
	         
	 
      }
      else	
      return true;
   }


   // Backspace must be disabled only when not in a form element
   if( keycode == 8 )    // Tab
   {
      if( (srcEl.type == 'text' && !srcEl.readOnly) || srcEl.type == 'textarea')
      { 
         
         return true;
      }

		CancelKeyEvent(e);
		return false;
   }

   for( var i=0; i < SingleCodes.length; i++ ) // Cancel F5, F6, F11
   {
      if( keycode == SingleCodes[i] )
      {	 
		CancelKeyEvent(e);
		return false;
      }
   }

   for( var i=0; i < CtrlCodes.length; i++ )
   {
      if( (keycode == CtrlCodes[i]) && ctrlKey && !altKey)
      {
		CancelKeyEvent(e);
		return false;
      }
   }

   for( var i=0; i < AltCodes.length; i++ )
   {
      if( (keycode == AltCodes[i]) && altKey )
      {
         alert('This Alt key is disabled');  // does not work without this line
         CancelKeyEvent(e);
         return false;
      }
   }

   return true;
}

function ProcessKey(keycode)
{
   //alert(keyCode);
 //Trap Escape key
  if (keycode == 27)	
 {    
    if (getBrowseMode()=='1')
    {       
       setBrowseMode('0');       
    }
    else
    {
       setBrowseMode('1');              
    }
    focusFirstControl();
 }
 else //PageUp
 if (keycode == 33)	
 {    
    if (getBrowseMode()=='1')
    {     
       if (!currentQuestionIsFirst())
       {
          if (parent.document.getElementById('NAV_GOBACK'))
             parent.document.getElementById('NAV_GOBACK').click();    
       }
       else
       if (FindElementByName('GOTOQ'))	 
          FindElementByName('GOTOQ').value = FindElementByName('QLABEL').value;
    }    
 }
 else //PageDown
 if (keycode == 34)	
 {    
    if (getBrowseMode()=='1')
    {
      if (!currentQuestionIsLast())
      { 
	 if (parent.document.getElementById('NAV_BROWSENEXT'))	
            parent.document.getElementById('NAV_BROWSENEXT').click();   
      }
      else
      if (FindElementByName('GOTOQ'))
         FindElementByName('GOTOQ').value = FindElementByName('QLABEL').value;
    }    
 }
 else //Home
 if (keycode == 36)	
 {    
    if (getBrowseMode()=='1')
    {       
        if (!currentQuestionIsFirst())
        {
           if (FindElementByName('GOTOQ')) 
           {
              FindElementByName('GOTOQ').selectedIndex = FindElementByName('GOTOQ').length-1;
              parent.document.getElementById('NAV_GOTOQ').click();             
            }
        }
        else
        if (FindElementByName('GOTOQ'))
           FindElementByName('GOTOQ').value = FindElementByName('QLABEL').value;
    }    
 }
else //End
 if (keycode == 35)	
 {    
    if (getBrowseMode()=='1')
    {  				
       if (!currentQuestionIsLast())
       {		
          if (FindElementByName('GOTOQ')) 
          { 			
             FindElementByName('GOTOQ').selectedIndex = FindElementByName('GOTOQ')[0];
             parent.document.getElementById('NAV_GOTOQ').click();      
          }  
       }
       else if (FindElementByName('GOTOQ'))
       {       
          FindElementByName('GOTOQ').value = FindElementByName('QLABEL').value;
        }
    }    
 }

}

function PageKeyPress(e)
{
	if(window.event)
	{
		var keycode = window.event.keyCode;
	}
	else
	{
		var keycode = e.which;
	}
	
	ProcessKey(keycode)	
  
}

function getFirstInputControl()
{

 var firstInput = null;
 for (var i=0;i<parent.document.forms[0].elements.length;i++)
 {
	if (parent.document.forms[0].elements[i].type == 'text')
	{		
	   return parent.document.forms[0].elements[i];
	}
 }
 return null;
}

function QuestionListKeyDown(e)
{	
	var keycode;
	if(window.event)
	{
		keycode = window.event.keyCode;			
	}
	else if (e)
	{
		keycode = e.which;				
	}   
		
	if (keycode == 13 && !parent.document.getElementById('NAV_GOTOQ').disabled) 
	{
		parent.document.getElementById('NAV_GOTOQ').click();        
	}
  
}

function setInputControlsState(disabled)
{

 var ltiframe = parent.document.getElementById("LONGTABLEIFRAME");
 if (ltiframe)
    ltiframe.enable = !disabled;
 

 parent.document.forms[0]['NAV_GOFWD'].disabled =  disabled;	

 var firstInput = null;
 for (var i=0;i<parent.document.forms[0].elements.length;i++)
 { 
        var elem = parent.document.forms[0].elements[i];

	if (elem.type == 'checkbox' || elem.type == 'radio' || elem.type == 'textarea' || elem.type == 'text' || 
	    (elem.type == 'button' && elem.name != 'NAV_GOBACK'  && elem.name != 'NAV_BROWSENEXT' && elem.name != 'BtnShowRosterTreeView'))
	{				
		elem.disabled = disabled;			
		
		if (elem.type == 'text' && !firstInput && !disabled)
			firstInput = elem;
	}
 }

 if(!disabled) 
    for (var i=0;i<parent.document.forms[0].elements.length;i++)
    { 
        var elem = parent.document.forms[0].elements[i];

	if (elem.type == 'checkbox')
	{		

		if (elem.checked)
		{
			ExclusiveChoiceClick(elem.name);
                }
	}
    }

 if (parent.document.forms[0]['SCREEN'] && parent.document.forms[0]['SCREEN'].value == '1')
 for (var i=0;i<parent.document.forms[0].elements.length;i++)
 { 
        var elem = parent.document.forms[0].elements[i];

	if ((elem.type == 'radio' || elem.type == 'checkbox') && elem.checked)
	{
	   elem.click();
	   if (elem.type == 'checkbox')
		 elem.click();
		
        }

 }

 if (firstInput && !firstInput.disabled)
 {
    firstInput.focus(); 
    firstInput.select();
 }
}


function setBrowseMode(value)
{
 parent.document.forms[0]['BROWSEMODE'].value = value;

 var btnShowRosterTreeView = parent.document.getElementById("BtnShowRosterTreeView");
 if (btnShowRosterTreeView != null)
 {
   btnShowRosterTreeView.disabled = (value == 0);
 }
 var overlayDiv = parent.document.getElementById("OverlayDiv");
 if (overlayDiv != null)
 {
     parent.document.body.removeChild(overlayDiv);
 }

 if (value == 0 )
 {
    if (FindElementByName('GOTOQ'))
    {
        FindElementByName('GOTOQ').disabled = true;
        parent.document.getElementById('NAV_GOTOQ').disabled = true;
    }

    FindElementByName('NAV_QUIT').disabled = true;
    
    if (parent.document.getElementById('NAV_GOBACK'))
       parent.document.getElementById('NAV_GOBACK').disabled = true;

    if (parent.document.getElementById('NAV_BROWSENEXT'))
       parent.document.getElementById('NAV_BROWSENEXT').disabled = true;    

 }
 else
 {
   if (FindElementByName('GOTOQ'))	
   {
        FindElementByName('GOTOQ').disabled = false;
        parent.document.getElementById('NAV_GOTOQ').disabled = false;
   }
   FindElementByName('NAV_QUIT').disabled = false;
   
   if (parent.document.getElementById('NAV_GOBACK'))
      parent.document.getElementById('NAV_GOBACK').disabled = false;

   if (parent.document.getElementById('NAV_BROWSENEXT'))
      parent.document.getElementById('NAV_BROWSENEXT').disabled = false;
 }

 setInputControlsState(value == 1);

	if (FindElementByName('GOTOQ') && !FindElementByName('GOTOQ').disabled)
	{
		FindElementByName('GOTOQ').focus();  
	}
	else
	{
		focusFirstControl();
	}
   
 if (value == 0 && self.OpenAgendaExtension)
	self.OpenAgendaExtension();  
}

function getBrowseMode()
{
    return parent.document.forms[0]['BROWSEMODE'].value;
}

function getQuestionMaxAnswer(question)
{
    if (parent.document.forms[0][question + ':MAXANSWER'] == null)
   return null;
   else
       return parent.document.forms[0][question + ':MAXANSWER'].value; 
}

function getAnswerField(question)
{ 	
 var result = null;
 var maxAnswer = getQuestionMaxAnswer(question);
 if (maxAnswer == null)		
	return null;
 for (var i=1;i<=maxAnswer;i++)
 {
	result = parent.document.forms[0][question+':ANSWER:' + i];
	if (result != null && ((result.value == '') || (result.value == ' '))) // In Design, a value of ' ' is possible
		return result;   
 }
  
 return parent.document.forms[0][question+':ANSWER:' + maxAnswer]; 
}

function getQuestionCodeWidth(question)
{
   return parent.document.forms[0][question+':CODEWIDTH'].value; 
}


function UpdateOtherCheckboxesAvailablility(question) {
  var maxAnswer = getQuestionMaxAnswer(question);
  var elems = parent.document.forms[0].elements;
  var isMaxAnswerReached = false;
  var nbSelectedChoices = 0;

  for (var i = 0; i < elems.length; i++) {
    if (elems[i].type == 'radio' || elems[i].type == 'checkbox') {
      if ((getInputQuestion(elems[i]) == question) && (elems[i].checked)) {
        nbSelectedChoices++;
        if (nbSelectedChoices == maxAnswer) {
          isMaxAnswerReached = true;
          break;
        }
      }
    }
  } // for

  if (isMaxAnswerReached) {
    // Disable all unselected choices
    for (var j = 0; j < elems.length; j++) {
      if (elems[j].type == 'radio' || elems[j].type == 'checkbox') {
        if ((getInputQuestion(elems[j]) == question) && (!elems[j].checked)) {
          elems[j].disabled = true;
        }
      }
    } // for
  }
  else if (nbSelectedChoices == maxAnswer - 1) {
    // Re-enable unselected choices
    for (var j = 0; j < elems.length; j++) {
      if (elems[j].type == 'radio' || elems[j].type == 'checkbox') {
        if ((getInputQuestion(elems[j]) == question) && (!elems[j].checked)) {
          elems[j].disabled = false;
        }
      }
    } // for
  }
}

function UncheckAllFields(question) {
    var elems = parent.document.forms[0].elements;

    for (var i = 0; i < elems.length; i++) {
        if (elems[i].type == 'radio' || elems[i].type == 'checkbox') {
            if ((getInputQuestion(elems[i]) == question) && (elems[i].checked)) {
                elems[i].checked = false;
            }
        }
    }
}

function ClearDateFields(question) {
    var elems = parent.document.forms[0].elements;
    for (var i = 0; i < elems.length; i++) {
        var s = elems[i].name;
        if (s == question + '_YEAR' || s == question + '_MONTH' || s == question + '_DAY' || s == 'MASK_' + question) {
            elems[i].value = '';
        }
    }
}

function DateFieldOnChange(question) {
    UncheckAllFields(question);
}

function MaskFieldOnChange(question) {
    UncheckAllFields(question);
}

function updateAnswerField(question, value, multiple) {
    ClearDateFields(question);
    if (getAnswerField(question) == null) return;

    var answer = '';
    if (multiple) {
        UpdateOtherCheckboxesAvailablility(question);
        var maxAnswer = getQuestionMaxAnswer(question);

        var previous = null;
        for (var i = 1; i <= maxAnswer; i++) {
            var field = parent.document.forms[0][question + ':ANSWER:' + i];

            var customdata = parent.document.forms[0][question + ':CUSTOMDATA:' + i];
            var datalabel = parent.document.forms[0][question + ':DATALABEL:' + i];


            if (field.value != null && value != null && field.value.toUpperCase() == value.toUpperCase() && !valueIschecked(question, value)) {
                field.value = '';
                if (customdata) {
                    customdata.value = '';
                    datalabel = '';
                }
            }

            if (previous != null) {
                var prevcustomdata = parent.document.forms[0][question + ':CUSTOMDATA:' + getInputIndex(previous)];
                var prevdatalabel = parent.document.forms[0][question + ':DATALABEL:' + getInputIndex(previous)];

                previous.value = field.value;
                if (prevcustomdata) {
                    prevcustomdata.value = customdata.value;
                    prevdatalabel.value = datalabel.value;
                }


                field.value = '';
            }

            if (field.value == '')
                previous = field;

        }


        if (valueIschecked(question, value)) {
            var input = getAnswerField(question);

            checkValue(question, input.value, false);
            input.value = value;
        }
    }
    else {
        getAnswerField(question).value = value;
    }


}

function deleteToken(token, s) {
    var tLen = token.length;
    var result = '';
    for (var i = 0; i < s.length; i += tLen) {
        if (token != s.substr(i, tLen)) {
            result += s.substr(i, tLen);
        }
    }
    return result;
}

function tokenInStr(token, s) {
    var sLen = s.length;
    var tLen = token.length;

    for (var i = 0; i < sLen; i += tLen) {
        if (token == s.substr(i, tLen)) {
            return true;
        }
    }


    return false;
}

function checkValue(question, value, checked) {
    if (value == '')
        return;

    var elems = parent.document.forms[0].elements;

    for (var i = 0; i < elems.length; i++) {
        if (elems[i].type == 'radio' || elems[i].type == 'checkbox')
            if (getInputQuestion(elems[i]) == question && elems[i].value != null && value != null && elems[i].value.toUpperCase() == value.toUpperCase()) {
                elems[i].checked = checked;
                return;
            }
    };

}

function valueIsInputed(question, value) {
    var maxAnswer = getQuestionMaxAnswer(question);

    for (var i = 1; i <= maxAnswer; i++) {
        var field = parent.document.forms[0][question + ':ANSWER:' + i];

        if (field.value != null && value != null && field.value.toUpperCase() == value.toUpperCase())
            return true;
    }

    return false;
}

function valueIschecked(question, value) {
    var elems = parent.document.forms[0].elements;

    for (var i = 0; i < elems.length; i++) {
        if (elems[i].type == 'radio' || elems[i].type == 'checkbox')
            if (getInputQuestion(elems[i]) == question)
                if ((elems[i].checked) && (elems[i].value != null && value != null && elems[i].value.toUpperCase() == value.toUpperCase()))
                    return true;

    };

    return false;
}

function getInputIndex(input) {
    var index = input.name.lastIndexOf(':');
    return input.name.substr(index + 1, input.name.length - index);
}

function getInputQuestion(input) {
    var index = input.name.indexOf(':');

    if (index < 0)
        return input.name;
    else
        return input.name.substr(0, index);

}


function currentQuestionIsFirst() {
    var dropdown = FindElementByName('GOTOQ');
    var alias = FindElementByName('QLABEL').value;

    if (dropdown != null && dropdown[dropdown.length - 1].value != null) {
        return (dropdown && dropdown[dropdown.length - 1].value == alias);
    }
    else {
        return true;
    }
}

function currentQuestionIsLast() {
    //var alias = FindElementByName('QLABEL').value;   
    //return (FindElementByName('GOTOQ') && FindElementByName('GOTOQ').value == alias);

    var dropdown = FindElementByName('GOTOQ');
    var alias = FindElementByName('QLABEL').value; // intro		
    if (dropdown != null && dropdown[0].value != null && alias != dropdown[0].value) {
        return (dropdown && dropdown.value == dropdown[0].value);
    }
    else {
        return true;
    }
}

function getNextInput(input) {
    var index = getInputIndex(input);
    index++;

    var question = getInputQuestion(input);

    return parent.document.forms[0][question + ':ANSWER:' + (index)];
}

function shiftInputLeft(input) {
    var question = getInputQuestion(input);

    var current = input;
    var next = getNextInput(input);
    while (next != null) {

        var currentcustomdata = parent.document.forms[0][question + ':CUSTOMDATA:' + getInputIndex(current)];
        var currentdatalabel = parent.document.forms[0][question + ':DATALABEL:' + getInputIndex(current)];
        var nextcustomdata = parent.document.forms[0][question + ':CUSTOMDATA:' + getInputIndex(next)];
        var nextdatalabel = parent.document.forms[0][question + ':DATALABEL:' + getInputIndex(next)];


        if (currentcustomdata) {
            currentcustomdata.value = nextcustomdata.value;
            currentdatalabel.value = nextdatalabel.value;
        }

        current.value = next.value;
        next.value = '';
        if (nextcustomdata) {
            nextcustomdata.value = '';
            nextdatalabel.value = '';
        }

        current = next;
        next = getNextInput(current);
    }

}

function FocusChoice(question, value, checkchoice) {
    var elems = parent.document.forms[0].elements;
    var firstChoice = null;

    for (var i = 0; i < elems.length; i++) {
        if (elems[i].type == 'radio' || elems[i].type == 'checkbox') {
            if (firstChoice == null)
                firstChoice = elems[i];
            if ((getInputQuestion(elems[i]) == question || question == '') && (elems[i].value != null && value != null && elems[i].value.toUpperCase() == value.toUpperCase() || value == '')) {
                if (elems[i].type == 'radio' && question != '') {
                    if (checkchoice) {
                        elems[i].checked = true;
                        elems[i].click();
                    }

                }
                if (!elems[i].disabled)
                    elems[i].focus();

                return;
            }

        }
    };

    if (firstChoice != null && !firstChoice.disabled)
        firstChoice.focus();
}

function AnswerKeyUp(input, e) {
    if (window.event) {
        var keycode = window.event.keyCode;
    }
    else {
        var keycode = e.which;
    }
    //Exit if TAB or Escape or Shift or delete or arrows
    if (keycode == 9 || keycode == 27 || keycode == 16 || (keycode >= 33 && keycode <= 37) || keycode == 39)
        return;

    if (input.readOnly && (keycode == 46 || keycode == 8)) {
        input.value = '';
    }


    var question = getInputQuestion(input);

    if (keycode == 38 || keycode == 40) {
        FocusChoice(question, input.value, true);
        return;
    }

    var codeWidth = getQuestionCodeWidth(question);

    var answer = getAnswerField(question).value;

    var elems = parent.document.forms[0].elements;




    if (parent.document.forms[0][question + ':' + input.value] != null && parent.document.forms[0][question + ':' + input.value].disabled)
        input.value = '';

    for (var i = 0; i < elems.length; i++) {
        if (elems[i].type == 'radio' || elems[i].type == 'checkbox')
            if (getInputQuestion(elems[i]) == question) {
                var checked = elems[i].checked;

                elems[i].checked = valueIsInputed(question, elems[i].value);

                if (elems[i].checked != checked)
                    ExclusiveChoiceClick(getInputQuestion(elems[i]) + ':' + elems[i].value);
            }
    };

    if (input.value == '') {
        shiftInputLeft(input);
        input.select();
    }
    else
        if (input.value.length == codeWidth) {
            var nextInput = getNextInput(input);
            if (nextInput != null && !nextInput.disabled) {
                nextInput.focus();
            }
        }

}

function focusFirstControl() {
    var _browserMode = getBrowseMode();
    if (_browserMode == 0) {
        var input = getFirstInputControl();
        if (input) {
            if (!input.disabled) {
                // If in Design, make sur the answer field selection is not empty
                if ((input.value == '') && (parent.document.forms[0]['PROJECT'].value == '0')) {
                    input.value = ' ';
                }
                input.focus();
                input.select();
            }
        }
        else {
            FocusChoice('', '', false);
        }
    }
    else {
        if (FindElementByName('GOTOQ')) {
            FindElementByName('GOTOQ').focus();
        }
        else if (FindElementByName('NAV_QUIT')) {
            FindElementByName('NAV_QUIT').focus();
        }
    }
}

function GetEventSource(e) {
    if (window.event) { return window.event.srcElement; }
    else if (e.srcElement) { return e.srcElement; }
    else if (e.target) { return e.target; }
    else return null;
}

function FindElementByName(name) {
    var ctlArray = parent.document.getElementsByName(name);
    if (ctlArray != null && ctlArray.length > 0) {
        return ctlArray[0];
    }
    else {
        return null;
    }
}

function CancelKeyEvent(e) {
    if (window.event) {
        window.event.cancelBubble = true;
        window.event.keyCode = 0;
        window.event.returnValue = false;
    }
    else if (e) {
        e.cancelBubble = true;
        e.returnValue = false;
        if (e.preventDefault) {
            e.preventDefault();
        }
    }
    return false;
}

function SubmitOnEnter(e) {
    var source = GetEventSource(e);
    if (!source || source.type != "textarea") {
        var element = parent.document.getElementsByName("NAV_GOFWD")[0];
        if (element) {
            CancelKeyEvent(e);
            element.click();
        }
    }
}


function GetTopLeftOffset(node) {
    var x = 0;
    var y = 0;
    while (node && !isNaN(node.offsetLeft) && !isNaN(node.offsetTop)) {
        x += node.offsetLeft - node.scrollLeft;
        y += node.offsetTop - node.scrollTop;
        node = node.offsetParent;
    }
    return { top: y, left: x };
} 